<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'status', 'id_user', 'banner');
    protected $visible = array('name', 'description', 'status', 'id_user', 'banner');

    public function prestations()
    {
        return $this->hasMany('App\Models\Prestation', 'id_category');
    }

    public function shops()
    {
        return $this->hasMany('App\Models\Shop', 'id_category');
    }

}